function shape = ykshaperead( filename )
% shape = ykshaperead( filename )
% 
% Function to read in shapefiles. It uses the shp_read mex files created by
% James P. LeSage. It produces a differently formatted output than his
% script, more like the shaperead function from the Mathworks Mapping
% Toolbox. 
% 
% Yannick Kremer
% 
% Modified after shape_read.m written by: James P. LeSage 12/2003
% Texas State University
% Department of Finance & Economics
% San Marcos, TX 78666
% jlesage@spatial-econometrics.com


% Read in shapefile and dbf file using the original mex files:
[cartex,cartey,xmin,xmax,ymin,ymax,nvertices,nparts,xc,yc] = shp_read(filename);
[ datamatrix, vnames ] = dbf_read( filename );

% Break nan separated data sets up into cells
x = nansnip( cartex ); 
y = nansnip( cartey );

shape = struct( ); 

% Format data into a structure
for idx = 1: length( xmin ),
%   First the geometric parameters from the shapefile itself
    shape( idx ).X = forcerow( x{ idx } );
    shape( idx ).Y = forcerow( y{ idx } );
    shape( idx ).xmin =  xmin( idx ) ;
    shape( idx ).ymin =  ymin( idx ) ;
    shape( idx ).xmax =  xmax( idx ) ;
    shape( idx ).ymax =  ymax( idx ) ;
    shape( idx ).nvertices =  nvertices( idx ) ;
    shape( idx ).nparts =  nparts( idx ) ;
    shape( idx ).xc =  xc( idx ) ;
    shape( idx ).yc =  yc( idx ) ;
    
%   Now add the data from the dbf file.
    for variable = 1: length( vnames ),
       shape( idx).( cell2mat( vnames( variable ) ) ) = datamatrix( idx, variable );
    end
        
end

